/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.target;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.target.CommonTargeting;
import com.ibm.hwmca.fw.target.Target;
import com.ibm.hwmca.fw.target.TargetActionListener;
import com.ibm.hwmca.fw.target.TargetRetriever;
import com.ibm.hwmca.fw.tasklet.TaskletClientExitInterface;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CommonTargetingTaskletExit
implements TaskletClientExitInterface,
TargetRetriever,
Serializable {
    private static final String TRACE_MASKT = "XCMTEXTT";
    private static final String TRACE_MASKF = "XCMTEXTF";
    private static final String TRACE_MASKD = "XCMTEXTD";
    private Target[] targets = null;
    private TargetActionListener[] actions = null;
    private int type;
    private ObjectId[] selectedTargetIds = null;
    private Object targetActionListenerKey = null;
    private boolean multiSelect = false;
    private String helpInfo = null;
    private LocalizableText[] columnInfo = null;
    private LocalizableText panelTitle = null;
    private LocalizableText panelText = null;
    private transient HashMap actionMap = new HashMap();
    private int actionKey = 0;

    CommonTargetingTaskletExit(TargetRetriever retriever, String taskid, boolean multiSelect, int type, Target[] realTargets) {
        TargetActionListener[] tal;
        Trace.trace(TRACE_MASKF, "-> CommonTargetingTaskletExit.ctor");
        this.type = type;
        this.multiSelect = multiSelect;
        this.panelTitle = retriever.getPanelTitle(taskid);
        this.panelText = retriever.getPanelText(taskid);
        this.helpInfo = retriever.getPanelHelpInfo(taskid);
        this.columnInfo = retriever.getColumnHeaders(taskid);
        if (realTargets != null) {
            this.targets = new Target[realTargets.length];
            for (int i = 0; i < realTargets.length; ++i) {
                this.targets[i] = new Target(realTargets[i].getObjectId(), realTargets[i].getName());
                this.targets[i].setColumnData(realTargets[i].getColumnData());
            }
        }
        if ((tal = retriever.getActions(taskid)) != null) {
            this.actions = this.buildExitActions(tal);
        }
        Trace.trace(TRACE_MASKF, "<- CommonTargetingTaskletExit.ctor");
    }

    private TargetActionListener[] buildExitActions(TargetActionListener[] tal) {
        TargetActionListener[] actions = new ExitActionListener[tal.length];
        for (int i = 0; i < tal.length; ++i) {
            ++this.actionKey;
            String key = "Action" + Integer.toString(this.actionKey);
            this.actionMap.put(key, tal[i]);
            actions[i] = new ExitActionListener(tal[i], key);
        }
        return actions;
    }

    ObjectId[] getSelectedTargetIds() {
        Trace.trace(TRACE_MASKF, "<>CommonTargetingTaskletExit.getSelectedTargetIds returning: " + this.selectedTargetIds);
        return this.selectedTargetIds;
    }

    Object getTargetActionListenerKey() {
        Trace.trace(TRACE_MASKF, "<>CommonTargetingTaskletExit.getTargetActionListenerKey returning: " + this.targetActionListenerKey);
        return this.targetActionListenerKey;
    }

    Map getActionMap() {
        return this.actionMap;
    }

    public Object exit() {
        Trace.trace(TRACE_MASKF, "-> CommonTargetingTaskletExit.exit");
        Serializable returnValue = this;
        try {
            CommonTargeting ct = null;
            if (this.type == 1) {
                Trace.trace(TRACE_MASKF, "showing action panel");
                ct = CommonTargeting.showTargetActionPanel(this, null, this.multiSelect, null);
            } else {
                Trace.trace(TRACE_MASKF, "showing selection panel");
                ct = CommonTargeting.showTargetSelectionPanel(this, null, this.multiSelect, null);
            }
            Target[] selectedTargets = ct.getSelectedTargets();
            if (selectedTargets != null) {
                Trace.trace(TRACE_MASKF, "selected targets has length of " + selectedTargets.length);
                this.selectedTargetIds = new ObjectId[selectedTargets.length];
                for (int i = 0; i < selectedTargets.length; ++i) {
                    this.selectedTargetIds[i] = selectedTargets[i].getObjectId();
                    Trace.trace(TRACE_MASKF, "selected target[" + i + "] is " + this.selectedTargetIds[i]);
                }
            } else {
                Trace.trace(TRACE_MASKF, "selected targets is null");
                this.selectedTargetIds = null;
            }
            ExitActionListener action = (ExitActionListener)ct.getTargetActionListener();
            if (action != null) {
                this.targetActionListenerKey = action.getKey();
                Trace.trace(TRACE_MASKF, "action has key of " + this.targetActionListenerKey);
            } else {
                Trace.trace(TRACE_MASKF, "action is null");
                this.targetActionListenerKey = null;
            }
        }
        catch (Exception e) {
            returnValue = new HException(e);
        }
        Trace.trace(TRACE_MASKF, "<- CommonTargetingTaskletExit.exit");
        return returnValue;
    }

    public Target[] getTargets(String taskid, Target[] target) {
        return this.targets;
    }

    public TargetActionListener[] getActions(String taskid) {
        return this.actions;
    }

    public LocalizableText getPanelTitle(String taskid) {
        return this.panelTitle;
    }

    public LocalizableText getPanelText(String taskid) {
        return this.panelText;
    }

    public String getPanelHelpInfo(String taskid) {
        return this.helpInfo;
    }

    public LocalizableText[] getColumnHeaders(String taskid) {
        return this.columnInfo;
    }

    private class ExitActionListener
    implements TargetActionListener,
    Serializable {
        private LocalizableText name = null;
        private TargetActionListener[] subActions = null;
        private ClassId[] types = null;
        private String key = null;

        public ExitActionListener(TargetActionListener realAction, String key) {
            this.key = key;
            this.name = realAction.getActionName();
            this.types = realAction.getAllowedTypes();
            TargetActionListener[] tal = realAction.getSubActions();
            if (tal != null) {
                this.subActions = CommonTargetingTaskletExit.this.buildExitActions(tal);
            }
        }

        public void performAction(Target[] target) {
            throw new UnsupportedOperationException("performAction not allowed for ExitActionListener objects");
        }

        public LocalizableText getActionName() {
            return this.name;
        }

        public TargetActionListener[] getSubActions() {
            return this.subActions;
        }

        public ClassId[] getAllowedTypes() {
            return this.types;
        }

        public String getKey() {
            return this.key;
        }
    }
}

